/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.decoration.bracket;

import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.decoration.bracket.BracketBlock;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.function.Predicate;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class BracketedBlockEntityBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<BracketedBlockEntityBehaviour> TYPE = new BehaviourType();
    private class_2680 bracket;
    private boolean reRender;
    private Predicate<class_2680> pred;

    public BracketedBlockEntityBehaviour(SmartBlockEntity be) {
        this(be, state -> true);
    }

    public BracketedBlockEntityBehaviour(SmartBlockEntity be, Predicate<class_2680> pred) {
        super(be);
        this.pred = pred;
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    public void applyBracket(class_2680 state) {
        this.bracket = state;
        this.reRender = true;
        this.blockEntity.notifyUpdate();
        class_1937 world = this.getWorld();
        if (world.field_9236) {
            return;
        }
        this.blockEntity.method_11010().method_30101((class_1936)world, this.getPos(), 3);
    }

    public void transformBracket(StructureTransform transform) {
        if (this.isBracketPresent()) {
            class_2680 transformedBracket = transform.apply(this.bracket);
            this.applyBracket(transformedBracket);
        }
    }

    @Nullable
    public class_2680 removeBracket(boolean inOnReplacedContext) {
        if (this.bracket == null) {
            return null;
        }
        class_2680 removed = this.bracket;
        class_1937 world = this.getWorld();
        if (!world.field_9236) {
            world.method_20290(2001, this.getPos(), class_2248.method_9507((class_2680)this.bracket));
        }
        this.bracket = null;
        this.reRender = true;
        if (inOnReplacedContext) {
            this.blockEntity.sendData();
            return removed;
        }
        this.blockEntity.notifyUpdate();
        if (world.field_9236) {
            return removed;
        }
        this.blockEntity.method_11010().method_30101((class_1936)world, this.getPos(), 3);
        return removed;
    }

    public boolean isBracketPresent() {
        return this.bracket != null;
    }

    public boolean isBracketValid(class_2680 bracketState) {
        return bracketState.method_26204() instanceof BracketBlock;
    }

    @Nullable
    public class_2680 getBracket() {
        return this.bracket;
    }

    public boolean canHaveBracket() {
        return this.pred.test(this.blockEntity.method_11010());
    }

    @Override
    public ItemRequirement getRequiredItems() {
        if (!this.isBracketPresent()) {
            return ItemRequirement.NONE;
        }
        return ItemRequirement.of(this.bracket, null);
    }

    @Override
    public boolean isSafeNBT() {
        return true;
    }

    @Override
    public void write(class_2487 nbt, boolean clientPacket) {
        if (this.isBracketPresent() && this.isBracketValid(this.bracket)) {
            nbt.method_10566("Bracket", (class_2520)class_2512.method_10686((class_2680)this.bracket));
        }
        if (clientPacket && this.reRender) {
            NBTHelper.putMarker((class_2487)nbt, (String)"Redraw");
            this.reRender = false;
        }
        super.write(nbt, clientPacket);
    }

    @Override
    public void read(class_2487 nbt, boolean clientPacket) {
        if (nbt.method_10545("Bracket")) {
            this.bracket = null;
            class_2680 readBlockState = class_2512.method_10681(this.blockEntity.blockHolderGetter(), (class_2487)nbt.method_10562("Bracket"));
            if (this.isBracketValid(readBlockState)) {
                this.bracket = readBlockState;
            }
        }
        if (clientPacket && nbt.method_10545("Redraw")) {
            this.getWorld().method_8413(this.getPos(), this.blockEntity.method_11010(), this.blockEntity.method_11010(), 16);
        }
        super.read(nbt, clientPacket);
    }
}

